// SetCHExtRefID.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "SetCHExtRefID.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#if defined WPPCS
/////////////////////////////////////////////////////////////////////////////
// CSetCHExtRefID dialog


CSetCHExtRefID::CSetCHExtRefID(CWnd* pParent /*=NULL*/)
	: CDialog(CSetCHExtRefID::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetCHExtRefID)
	m_ExtRefID = _T("");
	//}}AFX_DATA_INIT
}
CSetCHExtRefID ::CSetCHExtRefID(IApplication *pApp):CDialog(CSetCHExtRefID::IDD, NULL)
{
	pApplication = pApp;
	
}

void CSetCHExtRefID::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetCHExtRefID)
	DDX_Control(pDX, IDC_EXTREFID, m_CtlExtRefID);
	DDX_Control(pDX, IDC_CHLIST, m_CHLsit);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Text(pDX, IDC_EXTREFID, m_ExtRefID);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetCHExtRefID, CDialog)
	//{{AFX_MSG_MAP(CSetCHExtRefID)
	ON_BN_CLICKED(IDSET, OnSet)
	ON_BN_CLICKED(IDCLEAR, OnClear)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_CHLIST, OnSelchangeChlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetCHExtRefID message handlers
BOOL CSetCHExtRefID::OnInitDialog() 
{
	CDialog::OnInitDialog();
	LoadAccounts();
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
void CSetCHExtRefID :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctid;
				sAcctid.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctid);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
}
void CSetCHExtRefID::OnSet() 
{
		BSTR bstrExtRefID =::SysAllocString(L"");
		UpdateData(TRUE);
		//select CHid
		long lCHID;
		int index_CH = m_CHLsit.GetCurSel();
		if (index_CH < 0)
			lCHID = 0;
		else
		{
			CString sCHID;
			m_CHLsit.GetLBText(index_CH,sCHID);
			lCHID = _wtoi(sCHID);
		}
		bstrExtRefID = m_ExtRefID.AllocSysString();
		// set the external reference ID to card holder
		long lStatus;
		pApplication->SetExtRefIDByCHID(lCHID,bstrExtRefID,&lStatus);
		// get corresponding Status values
		if ( lStatus == 301)
		{
			AfxMessageBox(L"Invalid Card Holder ID");
			return;
		}
		if (lStatus == 401)
		{
			AfxMessageBox(L"Invalid ExtRefID");
			return;
		}
		if(lStatus == 402)
		{
			AfxMessageBox(L"ExtRefID Already Exists");
			return;
		}
		if(lStatus == 404)
		{
			AfxMessageBox(L"Invalid ExtRefID Length");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Set ExtRefID Failed");
			return;
		}
		if ( lStatus == 0)
		{
			AfxMessageBox(L"Set ExtRefID Succeeded");
			m_CtlExtRefID.SetWindowText(L"");
			return;
			//CDialog::OnOK();
		}
	
	UpdateData(FALSE);
}

void CSetCHExtRefID::OnClear() 
{
		//select CHid
		m_CtlExtRefID.SetWindowText(L"");
		long lCHID;
		int index_CH = m_CHLsit.GetCurSel();
		if (index_CH < 0)
			lCHID = 0;
		else
		{
			CString sCHID;
			m_CHLsit.GetLBText(index_CH,sCHID);
			lCHID = _wtoi(sCHID);
		}
		// Clear external reference ID of card holder
		long lStatus;
		pApplication->ClearExtRefIDByCHID(lCHID,&lStatus);
		// get corresponding Status values
		if ( lStatus == 301)
		{
			AfxMessageBox(L"Invalid Card Holder ID");
			return;
		}
		if ( lStatus == 403)
		{
			AfxMessageBox(L"ExtRefID Not Exist");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Clear ExtRefID Failed");
			return;
		}
		if ( lStatus == 0)
		{
			AfxMessageBox(L"Clear ExtRefID Succeeded");
			//m_CtlExtRefID.SetWindowText(L"");
			return;
			//CDialog::OnOK();
		}

	
}
void CSetCHExtRefID ::LoadCardHolders()
{
		BSTR bstrAcctName;
		//select Accountid
		long lAcctID;
		int index_Acct = m_AcctList.GetCurSel();
		if (index_Acct < 0)
			lAcctID = 0;
		else
		{
			CString sAcctID;
			m_AcctList.GetLBText(index_Acct,sAcctID);
			lAcctID = _wtoi(sAcctID);
		}
		//get the Account Name by AccountID
		pApplication->GetAccountNameByAcctID(lAcctID,&bstrAcctName);

		_variant_t vCHs;
		vCHs.Clear();
		pApplication->GetCardHoldersByAccountName(bstrAcctName,&vCHs); // get card holder details of particular account  in WP-CS database server
		
		if(vCHs.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ICardHolder *pCH = NULL;
		
		COleSafeArray sa(vCHs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ICardHolder,(void**)&pCH);
			if (pCH != NULL)
			{
				CString sCHid;
				sCHid.Format(L"%ld",pCH->CardHolderID);
				m_CHLsit.AddString(sCHid);
				pCH->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_CHLsit.SetCurSel(0);
}
void CSetCHExtRefID::OnSelchangeAcctlist() 
{
	
	m_CtlExtRefID.SetWindowText(L"");
	m_CHLsit.ResetContent();
	LoadCardHolders();
}

void CSetCHExtRefID::GetCHDetails()
{
		//select CHid
		long lCardHolderID;
		int index_CH = m_CHLsit.GetCurSel();
		if (index_CH < 0)
			lCardHolderID = 0;
		else
		{
			CString sCHid;
			m_CHLsit.GetLBText(index_CH,sCHid);
			lCardHolderID = _wtoi(sCHid);
		}
		// Getparticular card holder details
		_variant_t vCH;
		vCH.Clear();
		pApplication->GetCardHolderByCardHolderID(lCardHolderID,&vCH);
		ICardHolderPtr pcardholder(vCH.pdispVal);

		if(vCH.vt ==  VT_EMPTY)
		{
			return;
		}
		UpdateData(TRUE);
		if( vCH.vt & VT_DISPATCH)
		{		
			m_ExtRefID =CString(((LPWSTR)pcardholder->ExtRefID));
			
		}
		UpdateData(FALSE);
		if(NULL != vCH.pdispVal)
		{
			vCH.Clear();
		}
}

void CSetCHExtRefID::OnSelchangeChlist() 
{
	GetCHDetails();
	
}

#endif //WPPCS